--this is a include file for unstables in level tutorial
require 'g_level'

--here I'm creating a frame for the basic unstable
unst_layer = 4

function create_wooden_unstable(x,y)
    local segment_width = 170.0
    local vertical_offset = 70.0

    local unst_id = g_level.give_id()
    lua:unstablefloor_create(unst_id, 10.0, 1.0,unst_layer) --code, appeartime, disappeartime (in something),layer

    local seg_id = g_level.give_id()
    lua:create_segment_with_code(x-(segment_width/2), y, x+(segment_width/2),  y, seg_id)
    lua:upload_segmentstrip()

    lua:unstablefloor_segmentstrip(unst_id, seg_id) --floorcode, segmentstrip code
    
    local scale = 0.75
    local width = 128.0*scale
    local height = 128.0*scale
    lua:create_sprite("unstable_appear", ST_ANIMATED,"wooden_unstable_appear", x,y-vertical_offset) 
    lua:sprite_shape("unstable_appear",ST_ANIMATED,width, height)
    lua:create_sprite("rumble", ST_ANIMATED,"wooden_unstable_rumble", x,y-vertical_offset) 
    lua:sprite_shape("rumble",ST_ANIMATED,width, height)
    lua:create_sprite("unstable_dissappear", ST_ANIMATED,"wooden_unstable_disappear", x,y-vertical_offset) 
    lua:sprite_shape("unstable_dissappear",ST_ANIMATED,width, height)

    lua:unstablefloor_animations(unst_id,"unstable_appear","unstable_dissappear","rumble") --code, appear, disappear, rumble

    --lua:create_sound("appear","data/music/effect_stereo.ogg", 360.0, 0.0, 0.0)
    --lua:create_sound("disappear","data/music/effect_stereo.ogg", 360.0, 0.0, 0.0)
    --lua:create_music("rumble","data/music/disturbed.ogg")
    --lua:unstablefloor_audio(unst_id,"appear","disappear","rumble") --code, appear_sound, disappear_sound, rumble_sound
end

--LOAD GRAPHICS
local delay = 0.025
lua_init_texture_animation("wooden_unstable_disappear","data/images/lvl_forest/unstablefloor/", 26, MODE_ONCE, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:animation_add_frame("wooden_unstable_disappear", "transparent", delay)

local delay = 0.125
lua_init_texture_animation("wooden_unstable_appear","data/images/lvl_forest/unstablefloor/disappear/", 10, MODE_ONCE, DIRECTION_FORWARD, delay, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)

--lua_init_texture("wooden_unstable_appear", "data/images/unstablefloor_1.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
--lua_init_texture("wooden_unstable_disappear", "data/images/unstablefloor_1.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
--lua_init_texture("wooden_unstable_rumble", "data/images/unstablefloor_1.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)

lua_init_texture("wooden_unstable_rumble_1", "data/images/lvl_forest/unstablefloor/0001.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("wooden_unstable_rumble_2", "data/images/lvl_forest/unstablefloor/0002.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("wooden_unstable_rumble_3", "data/images/lvl_forest/unstablefloor/0003.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("wooden_unstable_rumble_4", "data/images/lvl_forest/unstablefloor/0004.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("wooden_unstable_rumble_5", "data/images/lvl_forest/unstablefloor/0005.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)

lua:init_subtexture("wooden_unstable_rumble_1","wooden_unstable_rumble_1", 0.0, 0.0, 1.0, 1.0)
lua:init_subtexture("wooden_unstable_rumble_2","wooden_unstable_rumble_2", 0.0, 0.0, 1.0, 1.0)
lua:init_subtexture("wooden_unstable_rumble_3","wooden_unstable_rumble_3", 0.0, 0.0, 1.0, 1.0)
lua:init_subtexture("wooden_unstable_rumble_4","wooden_unstable_rumble_4", 0.0, 0.0, 1.0, 1.0)
lua:init_subtexture("wooden_unstable_rumble_5","wooden_unstable_rumble_5", 0.0, 0.0, 1.0, 1.0)

local delay = 0.05
lua:init_animation("wooden_unstable_rumble",MODE_PINGPONG,DIRECTION_FORWARD)
lua:animation_add_frame("wooden_unstable_rumble","wooden_unstable_rumble_1",delay)
lua:animation_add_frame("wooden_unstable_rumble","wooden_unstable_rumble_2",delay)
lua:animation_add_frame("wooden_unstable_rumble","wooden_unstable_rumble_3",delay)
lua:animation_add_frame("wooden_unstable_rumble","wooden_unstable_rumble_4",delay)
lua:animation_add_frame("wooden_unstable_rumble","wooden_unstable_rumble_5",delay)